package de.aoj.internal.test;

import junit.framework.TestCase;
import de.aoj.core.Aspects;
import de.aoj.core.EntityFactory;
import de.aoj.core.IInterceptor;
import de.aoj.core.IModel;
import de.aoj.core.Invocation;
import de.aoj.system.ILoggingAspect;

/**
 * @author via
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CoolTest extends TestCase {

    public static class TestAspect implements IInterceptor {
        static boolean invoked = false;
        public Object intercept(Invocation i) throws Throwable {
            invoked = true;
            return i.proceed();
        }
        public void testMe() { }
    }
    
    public static class TestInstanceAspect implements IInterceptor {
        static boolean invoked = false;
        public Object intercept(Invocation i) throws Throwable {
            invoked = true;
            return i.proceed();
        }
    }
    
    public static interface ITestEntity extends ITestModel {
    }
    
    public static interface ITestModel extends IModel {
        public String doStuff(String str);
        public void setIrgendwas(String str);
    }
    
    public static class TestModel implements ITestModel {
        public String doStuff(String s) {
            if (s != null) { 
                //>dieser Call geht an die Interceptorskette vorbei:
                setIrgendwas(s); 
                
                //>so k�nnte es sonst aussehen: nicht wirklich sch�n...
                ((ITestModel) Invocation.current().entity).setIrgendwas("mamma");
            }
            return s;
        }
        public void setIrgendwas(String str) {
            System.out.println("local call called");
        }
    }
    
    protected void setUp() throws Exception {
        Aspects.register(TestAspect.class, TestAspect.class);
        Aspects.register(TestInstanceAspect.class, TestInstanceAspect.class);
        Aspects.register(ILoggingAspect.class, ILoggingAspect.Default.class);
        Aspects.global(ILoggingAspect.class);
        Aspects.global(TestAspect.class);
    }
    
    public void testRegisterGlobal() {
        ITestEntity e = (ITestEntity) EntityFactory.create(ITestEntity.class, new TestModel());
        String s = e.doStuff("mamma");
        assertTrue(TestAspect.invoked);
    }
    
    public void testRegister() {
        
        ITestEntity e = (ITestEntity) EntityFactory.create(ITestEntity.class, new TestModel());
        String s = e.doStuff("mamma");
        assertTrue(TestAspect.invoked);
    }
    
}
