package de.aoj.internal.test;

import de.aoj.core.IAspect;
import de.aoj.core.IInterceptor;
import de.aoj.core.IModel;
import de.aoj.core.Invocation;

/**
 * @author via
 *
 * @version $Id$
 */
public interface Test2 {

    interface Entity extends Model, ITestMixin, ITestAspect { }
    
    interface Model extends IModel {
        void setMamma(String s);
        String getMamma();
        String doStuff();
    }
    
    interface ITestMixin extends IAspect, IAspect.Mixin {
        void setMixinValue(String s);
        String getMinixValue();
    }
    
    class ModelImpl implements Model {
        String mamma;
        
        public void setMamma(String s) { this.mamma = s; }
        public String getMamma() { return this.mamma; }

        public String doStuff() {
            return "Model:" + this.mamma;
        }
        public boolean equals(Object arg0) {
            if (! (arg0 instanceof Model)) return false;
            
            Model m = (Model) arg0;
            return m.getMamma().equals(this.getMamma());
        }
        public String toString() {
            return this.mamma;
        }
    }
    
    class TestMixin implements ITestMixin {
        static boolean toStringCalled = false;
        String mixinValue = "sussi";
        public TestMixin() { toStringCalled = false; }
        public void setMixinValue(String s) { this.mixinValue = s; }
        public String getMinixValue() { return this.mixinValue; }
        public boolean equals(Object o) {
            if (! (o instanceof ITestMixin)) return false;
            
            ITestMixin m = (ITestMixin) o;
            return m.getMinixValue().equals(this.getMinixValue());
        }
        public String toString() {
            toStringCalled = true;
            return this.mixinValue;
        }
    }
    
    
    interface ITestAspect extends IAspect {
        String callAspectMethod(String s);
    }
    
    class TestAspect implements ITestAspect {
        public String callAspectMethod(String s) {
            return "Aspect:" + s;
        }
    }
    
    class CounterAspect implements IInterceptor {
        static int counter = 0;
        static int stored = 0;
        static void start() { stored = counter; }
        static int count() { return counter - stored; }
        public Object intercept(Invocation inv) throws Throwable {
            counter++;
            return inv.proceed();
        }
        public String toString() {
            return "(" + CounterAspect.class + ")";
        }
    }
}
