package de.aoj.internal.test;

import de.aoj.core.Aspects;
import de.aoj.core.IModel;
import de.aoj.system.IValidationAspect;
import de.aoj.system.ValidationAspect;

public interface Test3 {

    interface Entity extends Model, IValidationAspect {
        Aspects LOCAL = Aspects.forMe().define(IValidationAspect.class, ValidationEntityAspectImpl.class);
    }
    
    interface Model extends IModel {
        void setMamma(String s);
        String getMamma();
    }
    
    class ModelImpl implements Model {
        private String mamma;
        
        public void setMamma(String s) {
            this.mamma = s;
        }

        public String getMamma() {
            return this.mamma;
        }
        
    }

    class ValidationEntityAspectImpl extends ValidationAspect {
        public static boolean called = false; 
        public static boolean created = false; 
        public ValidationEntityAspectImpl() { created = true; }
        public boolean validate(IModel model) {
            called = true;
            Model m = (Model) model;
            boolean b = "mamma".equals(m.getMamma());
            if (! b) throw new IllegalStateException();
            return b;
        }
    }
    
}
