package de.aoj.system;

import de.aoj.core.IAspect;


public interface IPersistanceAspect extends IAspect {
    void setTable(String table);
    void store();
    
    public class Default implements IPersistanceAspect {
        public void store() {
            //per Reflection bau ein "update ...." auf und ausführen...
        }

        public void setTable(String table) {
            throw new UnsupportedOperationException();
        }
    }
    
    public class Dummy implements IPersistanceAspect {
        public void setTable(String table) {
        }
        
        public void store() {
        }
    }

}
