package de.aoj.system;

import de.aoj.core.IInterceptor;
import de.aoj.core.Invocation;

public interface ISynchronizedAspect extends IInterceptor {
    class Impl implements ISynchronizedAspect {
        public Object intercept(Invocation ctx) throws Throwable {
            synchronized(ctx.entity) {
                return ctx.proceed();
            }
        }
    }
}
