package de.aoj.system;

import java.util.HashMap;
import java.util.Map;

import de.aoj.core.Invocation;


public class LifecycleAspect implements ILifecycleAspect  {
    
    private static final Map matrix = new HashMap();
    static {
        matrix.put(State.NEW, new State[] { State.LOCKED });
        matrix.put(State.LOCKED, new State[] { State.MODIFIED, State.NEW });
        matrix.put(State.MODIFIED, new State[] { State.NEW, State.MODIFIED });
    }
    
    private State state;
    
    public LifecycleAspect() {
        this.state = State.NEW;
	}
    
    public Object intercept(Invocation ctx) throws Throwable {
        if (ctx.method.getName().startsWith("set") || ctx.method.getName().startsWith("add")) 
            this.setModified();

        return ctx.proceed();
    }

	public boolean isNew() {
        return this.state == State.NEW;
    }
	
    public boolean isModified() {
        return this.state == State.MODIFIED;
    }

	public void setModified() {
        toState(State.MODIFIED);
	}
    
    public void lock() {
        toState(State.LOCKED);
    }
    
    public boolean isLocked() {
        return this.state == State.LOCKED;
    }
    
    private void toState(State newState) {
        check(newState);
        this.state = newState;
    }

	private void check(State newState) {
        State[] allowed = (State[]) matrix.get(this.state);
        for (int i = 0; i < allowed.length; i++) {
            if (allowed[i] == newState) return;
        }
        throw new NotAllowedException("Cannot change state from " + this.state + " to " + newState);
    }
    
    public static class NotAllowedException extends RuntimeException {
        public NotAllowedException(String s) {
            super(s);
        }
    }
    
	public static class State {
        public static final State NEW = new State("NEW");
        public static final State MODIFIED = new State("MODIFIED");
        public static final State LOCKED = new State("LOCKED");

        private String name;
		private State(String name) { this.name = name; }
		public String toString() { return this.name; }
	}

}
