package de.aoj.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class Invocation {

    public final Method method;
    public final Object[] args;
    public final Object entity;
    public final IModel model;
    
    public final List members;
    private int current;
    
    private final Invocation last;
    private static ThreadLocal self = new ThreadLocal();
    
    private class MethodCaller implements IInterceptor {
        private Object member;
        MethodCaller(Object model) { this.member = model; }
        public Object intercept(Invocation ctx) throws Throwable {
            return ctx.method.invoke(member, ctx.args);
        }
    }

    Invocation(final Method method, final Object[] args, List members, Object actualMember, Object entity) {
        last = (Invocation) self.get();
        self.set(this);
        
        this.method = method;
        this.args = args;
        this.members = createCallingChain(members, actualMember); 
        this.current = 0;
        this.entity = entity;
        this.model = (IModel) members.get(0);
    }
    
    void restore() {
        self.set(this.last);
    }
    
    public static Invocation current() { return (Invocation) self.get(); }

    private List createCallingChain(List members, Object model) {
        List result = new ArrayList(members);
        result.add(new MethodCaller(model));
        return result;
    }
    
    public Object proceed() throws Throwable {
        Object i = this.members.get(current++);
        return (i instanceof IInterceptor) ? ((IInterceptor) i).intercept(this) : proceed();
    }
}
