package de.aoj.example3;

import de.aoj.core.Aspects;
import de.aoj.core.EntityFactory;
import de.aoj.core.IModel;
import de.aoj.system.IValidationAspect;
import de.aoj.system.ValidationAspect;

public class OrderPosition {
        
    public interface Entity extends IOrderPositionModel, IValidationAspect, IStandardAttributesAspect {
        Aspects LOCAL = Aspects.forMe().define(IValidationAspect.class, OrderPositionValidationAspect.class);
    }
    
    public static OrderPosition.Entity entity(Order.Entity order) {
        return (OrderPosition.Entity) EntityFactory.create(OrderPosition.Entity.class, new OrderPosition.Model(order));
    }
    
    public interface IOrderPositionModel extends IModel {
        Order.Entity getOrder();
        int getQuantity();
        void setQuantity(int quantity);
    }
    
    public static class Model implements IOrderPositionModel {

        private final Order.Entity order;
        private int quantity;
        
        public Model(Order.Entity order) {
            this.order = order;
        }        
        public Order.Entity getOrder() {
            return order;
        }
        public int getQuantity() {
            return quantity;
        }
        public void setQuantity(int quantity) {
            this.quantity = quantity;
        }
    }

    public static class OrderPositionValidationAspect extends ValidationAspect {

        public boolean validate(IModel model) {
            if (!(model instanceof IOrderPositionModel)) throw new IllegalArgumentException();
            
            return ( ((IOrderPositionModel) model).getQuantity() > 0 );
        }
    }
}
