package de.aoj.internal.test;

import junit.framework.TestCase;
import de.aoj.core.Aspects;
import de.aoj.core.EntityFactory;
import de.aoj.system.ILoggingAspect;

public class CoolTest3 extends TestCase {

    protected void setUp() throws Exception {
        Aspects.register(ILoggingAspect.class, ILoggingAspect.Default.class);
        Aspects.global(ILoggingAspect.class);
    }
    
    public void testEntityAspects() {
        System.out.println("testEntityAspects");
        Test3.Entity e = (de.aoj.internal.test.Test3.Entity) EntityFactory.create(Test3.Entity.class, new Test3.ModelImpl());
        assertTrue(Test3.ValidationEntityAspectImpl.created);
        assertFalse(Test4.ValidationEntityAspectImpl.created);
        e.setMamma("mamma");
        try {
            e.setMamma("occhio");
            fail("no invalid model thrown");
        } catch (IllegalStateException ex) {
            //>ignore
            assertTrue(Test3.ValidationEntityAspectImpl.called);
        }
    }
    
    public void testEntityAspectsInstances() {
        System.out.println("testEntityAspectsInstances");
        Test4.Entity e = (de.aoj.internal.test.Test4.Entity) EntityFactory.create(Test4.Entity.class, new Test4.ModelImpl());
        assertTrue(Test4.ValidationEntityAspectImpl.created);
        e.setLallo("lallo");
        try {
            e.setLallo("occhio");
            fail("no invalid model thrown");
        } catch (IllegalStateException ex) {
            //>ignore
            assertTrue(Test4.ValidationEntityAspectImpl.called);
        }
    }
    
    public void testPerJVMPerEntity() {
        System.out.println("testPerJVMPerEntity");
        Test4.Entity e = (de.aoj.internal.test.Test4.Entity) EntityFactory.create(Test4.Entity.class, new Test4.ModelImpl());
        Test4.Entity e2 = (de.aoj.internal.test.Test4.Entity) EntityFactory.create(Test4.Entity.class, new Test4.ModelImpl());

        assertEquals(Test4.PerJVMAspect.instances, 1);
        assertTrue(Test4.PerEntityAspect.instances > 1);
        
    }

}
