package de.aoj.internal.test;

import de.aoj.core.Aspects;
import de.aoj.core.IAspect;
import de.aoj.core.IModel;
import de.aoj.system.IValidationAspect;
import de.aoj.system.ValidationAspect;

public interface Test4 {

    interface Entity extends Model, IValidationAspect, IPerJVMAspect, IPerEntityAspect {
        Aspects LOCAL = Aspects.forMe()
            .define(IValidationAspect.class, ValidationEntityAspectImpl.class)
            .define(IPerEntityAspect.class, PerEntityAspect.class)
            .define(IPerJVMAspect.class, PerJVMAspect.class);
    }
    
    interface Model extends IModel {
        void setLallo(String s);
        String getLallo();
    }
    
    interface IPerJVMAspect extends IAspect {
        Instantiation TYPE = PerJVM;
    }
    
    interface IPerEntityAspect extends IAspect {
        Instantiation TYPE = PerEntity;
    }
    
    class ModelImpl implements Model {
        private String lallo;
        
        public void setLallo(String s) {
            this.lallo = s;
        }

        public String getLallo() {
            return this.lallo;
        }
    }
    
    class ValidationEntityAspectImpl extends ValidationAspect {
        public static boolean called = false; 
        public static boolean created = false; 
        public ValidationEntityAspectImpl() { created = true; }
        public boolean validate(IModel model) {
            called = true;
            Model m = (Model) model;
            boolean b = "lallo".equals(m.getLallo());
            if (! b) throw new IllegalStateException();
            return b;
        }
    }
    
    class PerJVMAspect implements IPerJVMAspect {
        public static int instances = 0;
        public PerJVMAspect() { instances++; }
    }
    
    class PerEntityAspect implements IPerEntityAspect {
        public static int instances = 0;
        public PerEntityAspect() { instances++; }
    }
}
