package de.aoj.internal.test.validation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import de.aoj.core.Aspects;
import de.aoj.core.IModel;
import de.aoj.system.IValidationAspect;
import de.aoj.system.ValidationAspect;


public class Order {
    
    public static interface Entity extends IOrderModel, IValidationAspect {
        Aspects LOCAL = Aspects.forMe().define(IValidationAspect.class, OrderValidationAspect.class);
    }

    public static interface IOrderModel extends IModel {
        List getPositions();
        void addPosition(OrderPosition.Entity position);
    }
    
    public static class Model implements IOrderModel {
        private List positions;
        
        public Model() {
            this.positions = new ArrayList();
        }
        public List getPositions() {
            return positions;
        }
        public void addPosition(OrderPosition.Entity position) {
            this.positions.add(position);
        }
    }
    
    public static class OrderValidationAspect extends ValidationAspect {
        
        public boolean validate(IModel model) {
            boolean result = true;
            
            if (!(model instanceof IOrderModel)) throw new IllegalArgumentException();
            
            for (Iterator iter = ((IOrderModel) model).getPositions().iterator(); iter.hasNext() && result;) {
                OrderPosition.Entity pos = (OrderPosition.Entity) iter.next();
                result = pos.isValid();
            }
            
            return result;
        }
    }

}
