package de.aoj.internal.test.validation;

import de.aoj.core.Aspects;
import de.aoj.core.IModel;
import de.aoj.system.IValidationAspect;
import de.aoj.system.ValidationAspect;

public class OrderPosition {
        
    public static interface Entity extends IOrderPositionModel, IValidationAspect {
        Aspects LOCAL = Aspects.forMe().define(IValidationAspect.class, OrderPositionValidationAspect.class);
    }
    
    public static interface IOrderPositionModel extends IModel {
        Order.Entity getOrder();
        void setOrder(Order.Entity order);
        int getQuantity();
        void setQuantity(int quantity);
    }
    
    public static class Model implements IOrderPositionModel {

        private Order.Entity order;
        private int quantity;
        
        public Order.Entity getOrder() {
            return order;
        }
        public void setOrder(Order.Entity order) {
            this.order = order;
        }
        public int getQuantity() {
            return quantity;
        }
        public void setQuantity(int quantity) {
            this.quantity = quantity;
        }
    }

    public static class OrderPositionValidationAspect extends ValidationAspect {

        public boolean validate(IModel model) {
            if (!(model instanceof IOrderPositionModel)) throw new IllegalArgumentException();
            
            return ( ((IOrderPositionModel) model).getQuantity() > 0 );
        }
    }
}
