package de.aoj.system;

import de.aoj.core.Invocation;

public abstract class SecureAspect implements ISecure {

    public SecureAspect() {
    }

    public Object intercept(Invocation ctx) throws Throwable {
        checkAccess(ctx.method.getName(), ctx.args);
        return ctx.proceed();
    }
    
	public abstract void checkAccess(String name, Object[] args) throws ISecure.Exception;

}
