/*
  garb.cpp
*/

#include <stdio.h>
#include <stdlib.h>
#include "struct.h"
#include "garb.h"

OBJ *garbage = NULL;

int nmall = 0;
     /* nmall: Contatore delle allocazioni di memoria non ancora liberate */

OBJ *alloc_obj()
{
  OBJ *p;

  if (garbage) {
    p = garbage;
    garbage = garbage->child;
    return p;
  } else
    return (OBJ *)mymalloc(sizeof(OBJ));
}

void free_obj(OBJ *p)
{
  p->child = garbage;
  garbage = p;
}

void destroy_garb()
{
  OBJ *p = garbage;

  while (p) {
    garbage = p;
    p = p->child;
    myfree(garbage);
  }
}

void *mymalloc(unsigned n)
{
  void *p = malloc(n);
  int c;

/*
  while (!(p = malloc(n)) && garbage) {
    p = (void *)garbage;
    garbage = garbage->child;
    myfree(p);
  }
*/

  if (p) {
    nmall++;
    return p;
  } else {
    fprintf(stderr, "Too many malloc()! (%d)\n", nmall);
    exit(1);
  }
}


void myfree(void *p)
{
  if (nmall == 0) {
    fprintf(stderr, "Too many free()!\n");
    exit(1);
  }

  free(p);
  nmall--;
}
