/*
  p97.c
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "garb.h"
#include "status.h"
#include "p97.h"
#include "parse.h"

static void destroy_all( void );

static int nobj = 0;

prolog::prolog(char *name, char *lib)
{
/* *** aggiusta readsoource */
  this_src = NULL;
  this_var_sp = this_sts_sp = NULL;
  if (!nobj++)
    if (runtime(lib) != 1) {
      status = ERR_LIB;
      return;
    }

  switch (readsource(name)) {
    case 1:
      status = DONOTHING;
      this_src = src;
      varc = 0;
      break;

    case 0:
      status = ERR_FNOTFOUND;
      break;

    case -1:
      status = ERR_PARSE;
      break;
  }
}

prolog::~prolog()
{
  extern int nmall;

  setptr();

  destroy_all();
  destroy_src(src);

  if (!(--nobj)) {
    destroy_garb();
    destroy_src(rt_src);
    printf("nmall = %d\n", nmall);
  }
}

prolog::solve(char *query_s)
{
  OBJ goal;
  int r;

  if (query_s) {
    if ((sread_cl(query, query_s) != 1) || !parse(query)) {
      status = ERR_PARSE_GOAL;
      return 0;
    }
    reset();
  } else if ((status != OK) && (status != DONOTHING))
    return 0;

  create_goal(query, &goal);
  setptr();

  if ((status == DONOTHING) && (solve_1st(goal.child, NULL))) {
	 status = OK;
	 copy_var();
	 r = 1;

  } else if (r = solve_back()) {
    status = OK;
    copy_var();
    r = 1;
  } else {
    reset_raw();
    status = FAIL;
    r = 0;
  }

  destroy_st(goal.child);
  getptr();

  return r;
}


void prolog::reset_raw()
{
  destroy_all();
  status = DONOTHING;
}

void prolog::reset()
{
  setptr();
  reset_raw();
  getptr();
}

void prolog::setptr()
{
  src = this_src;
  var_sp = this_var_sp;
  sts_sp = this_sts_sp;
}

void prolog::getptr()
{
  this_src = src;
  this_var_sp = var_sp;
  this_sts_sp = sts_sp;
}


void prolog::copy_var()
{
  STACK *p = var_sp;
  varc = 0;

  while (p) {
    if (((VAR *)p->data)->name[0] != '#') {
      strcpy(varv[varc].name, ((VAR *)p->data)->name);
      varv[varc++].value = getobj((((VAR *)p->data)->value));
    }
    p = p->prev;
  }
}

VAR *prolog::get_var(char *s)
{
  VAR *p = varv;

  for (p = varv; ((p - varv) < varc) && strcmp(s, p->name); p++);
  return (((p - varv) < varc) ? p : NULL);
}

void prolog::print_var()
{
  int n;

  setptr();

  printf("varc: %d, stato: %d\n", varc, status);
  for (n = varc; n--;)
    printf("%s = %s\n", varv[n].name, sget_var(varv[n].name));

  getptr();
}


static void destroy_all()
{
  release_var(NULL);
  destroy_sts();
}


/*
VAR *prolog::get_var(char *s)
{
  VAR* v;

  setptr();
  v = inlist_var(s);
  getptr();
  return v;
}
*/

char *prolog::sget_var(char *s)
{
  static char buf[LINE_L + 1];

  sprint_var(buf, get_var(s));
  unparse_list(buf);
  return buf;
}
