/*
  parse.c
*/

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "clause.h"
#include "struct.h"
#include "garb.h"
#include "stack.h"

#define STACK_N  10
#define BUF_L    LINE_L

typedef enum {
    xfy,           /* binario infisso, ass sx */
    yfx,           /* binario infisso, ass dx */
    xfx,           /* binario non associativo */
    fx             /* unario prefisso */
} type_t;

typedef struct {
  char name[NAME_L + 1];
  int  priority;
  type_t type;
} OPERATOR;

#define OP_N   20

OPERATOR opv[OP_N] = {
/*  { "+", 100, xfy },
  { "*", 50, xfy },
  { "=", 200, xfx },
  { "mod", 50, xfy },
  { "//", 50, xfy },
  { "is", 300, xfx },*/
  { "", 0, xfy }
};

#define mypop(s, stack)  (strcpy(s, (char *)((*stack)->data)), pop(stack))
#define mypush(s, stack) push(s, strlen(s) + 1, stack)

static int parse_list(char *dest, char *src);
static char *unparse_bracket(char **dest, char *src);
static char *parse_bracket(char **dest, char *src);
static void dump(char **dest, char *src);
static int parse2(char *dest);
static int member(char *s, STACK *p);
static void add(char *s, STACK **p);
static void eval(STACK **ond, STACK **otr);
static OPERATOR *otr_p(char *s);

int parse(char *dest)
{
  char s[LINE_L + 1];
  int r;

  if (r = parse_list(s, dest)) {
    inputp = s;
    return parse2(dest);
  }
  return r;
}

/*
void p_stack(PARSE_STACK *p)
{
  int n;
  printf("------s start\n");
  for (n = p->n; n; printf("%s\n", p->s[--n]));
  printf("------s end\n");
getchar();
}
*/


static void add(char *s, STACK **p)
{
  char newond[BUF_L + 1];

  sprintf(newond, " %s ( %s ) ", (char *)((*p)->data), s);
  pop(p);
  mypush(newond, p);
}

static void eval(STACK **ond, STACK **otr)
{
  char ond1[BUF_L + 1], ond2[BUF_L + 1], otr_s[BUF_L + 1];
  char buf[BUF_L + 1];

  mypop(ond2, ond);
  mypop(ond1, ond);
  mypop(otr_s, otr);
  sprintf(buf, " %s ( %s , %s ) ", otr_s, ond1, ond2);
  mypush(buf, ond);
}


static OPERATOR *otr_p(char *s)
{
  OPERATOR *p;

  assert(s);
  for (p = opv; p->name[0] && strcmp(p->name, s); p++);
  return p;
}


static int member(char *s, STACK *p)
{
  for (; p && strcmp((char *)(p->data), s); p = p->prev);
  return p ? 1 : 0;
}

static int parse2(char *dest)
{
  char *tok;
  char tmp[BUF_L + 1];
  STACK *ond_sp = NULL, *otr_sp = NULL;
  enum { operand_s, operator_s } status;
  OPERATOR *o;
  int r;

  *dest = '\0';
  status = operator_s;
  tok = mystrtok();

  while (tok[0] && strcmp(tok, ")")) {
    if (!strcmp(tok, "(")) {
      parse2(tmp);

      if (status == operator_s)
        mypush(tmp, &ond_sp);
      else
	add(tmp, &ond_sp);

      status = operand_s;

    } else if ((o = otr_p(tok))->name[0]) {
      OPERATOR *o1 = (otr_sp ? otr_p((char *)(otr_sp->data)) : NULL);

      if (o1) {
        if ((o->type == xfx) && member(o->name, otr_sp))
          return -1;

        if ((o->priority > o1->priority) || ((o->priority == o1->priority) && (o1->type == xfy)))
            eval(&ond_sp, &otr_sp);
      }

      mypush(tok, &otr_sp);
      status = operator_s;

    } else if (!strcmp(tok, ",")) {
      while (otr_sp)
        eval(&ond_sp, &otr_sp);

      mypop(tmp, &ond_sp);

      strcat(dest, " ");
      strcat(dest, tmp);
      strcat(dest, " , ");
      status = operator_s;

    } else {
      if (status == operand_s) {
        mypop(tmp, &ond_sp);
        strcat(dest, " ");
        strcat(dest, tmp);
      }
      mypush(tok, &ond_sp);
      status = operand_s;
    }

  tok = mystrtok();
  }

  while (otr_sp)
    eval(&ond_sp, &otr_sp);

  mypop(tmp, &ond_sp);
  strcat(dest, " ");
  strcat(dest, tmp);

  r = (ond_sp) ? -1 : 1;
  return r;
}

int op(OBJ *st)
{
  OPERATOR *p;

  assert(st->arity == 3);

  if (!(p = otr_p(st->child->brother->brother->name))->name[0])
    (p + 1)->name[0] = '\0';

  strcpy(p->name, st->child->brother->brother->name);
  p->priority = atoi(st->child->name);

  st = st->child->brother;
  if (!strcmp(st->name, "xfy"))
    p->type = xfy;
  else if (!strcmp(st->name, "yfx"))
    p->type = yfx;
  else if (!strcmp(st->name, "xfx"))
    p->type = xfx;
  else if (!strcmp(st->name, "fx"))
    p->type = fx;
  else
    return 0;

  return 1;
}


static int parse_list(char *dest, char *src)
{
  char *p = src;

  while (*p)
    if (*p == '[')
      p = parse_bracket(&dest, p);

    else
      *dest++ = *p++;

  *dest = '\0';
  return 1;
}

static void dump(char **dest, char *src)
{
  for (; *src; (*dest)++, src++)
    **dest = *src;
}

static char *parse_bracket(char **dest, char *src)
{
  int bracketc, pipe = 0;
  int elemc = 1;

  assert(*src == '[');

  for (src++; isspace(*src); src++);
  if (*src == ']') {
    dump(dest, " $ ");
    return src + 1;
  }

  dump(dest, " . ( ");
  for (bracketc = 0; *src != ']';)
    switch (*src) {
      case '(':
	bracketc++;
	**dest = *src++;
	(*dest)++;
	break;

      case ')':
	bracketc--;
	**dest = *src++;
	(*dest)++;
	break;

      case ',':
	if (bracketc == 0) {
	  elemc++;
	  dump(dest, " , . ( ");
	} else {
	  **dest = *src;
	  (*dest)++;
	}
	src++;
	break;

      case '|':
	dump(dest, " , ");
	pipe = 1;
	src++;
	break;

      case '[':
	src = parse_bracket(dest, src);
	break;

      default:
	**dest = *src++;
	(*dest)++;
    }


  if (!pipe)
    dump(dest, " , $ ");

  for (; elemc--; dump(dest, " ) "));

  return src + 1;
}


#define dump_c(c)  ((**dest = (c)), (*dest)++)

void unparse_list(char *dest)
{
  char buf[LINE_L + 1], *p = buf;

  strcpy(buf, dest);

  while (*p) {
    if ((*p == '.') || (*p == '$'))
      p = unparse_bracket(&dest, p);

    else
      *dest++ = *p++;
  }
  *dest = '\0';
}

static char *unparse_bracket(char **dest, char *src)
{
  int bracketc, elemc;


  if (*src == '$') {
    dump(dest, "[]");
    return src + 1;
  }

  src += 2;
  elemc = 1;
  bracketc = 0;
  dump_c('[');

  while (*src && elemc) {
    switch (*src) {
      case '$':
        dump(dest, "[]");
        src++;
        break;

      case '.':
        assert(*(src + 1) == '(');
        src += 2;
        elemc++;

        if (*src == '.')
          src = unparse_bracket(dest, src);
        break;

      case ',':
        if (bracketc == 0)
          if (*(src + 1) == '$')
            src++;
          else if (*(src + 1) == '.')
            dump_c(',');
          else
            dump_c('|');

        else
          dump_c(',');

        src++;
        break;

      case ')':
        if (bracketc == 0) {
          dump_c(']');
          src += elemc;
          elemc = 0;
        } else
          bracketc--;
        break;

      case '(':
        bracketc++;
        dump_c(*src);
        src++;
        break;

      default:
        dump_c(*src);
        src++;
    }
  }

  return src;
}