/*
  var.h
*/

#ifndef VAR_H
#define VAR_H

#include "struct.h"
#include "stack.h"

struct var_t {
  char name[NAME_L + 1];
  OBJ *value;
};

typedef struct var_t VAR;

extern STACK *var_sp;

VAR  *inlist_var(char *varname);
OBJ  *getobj(OBJ *st);
char *new_var(void);
void  link_var(OBJ *st, OBJ *st2);
STACK *mark_var( void );
void  release_var(STACK *p);
void  free_var(VAR *p);
void  print_var(VAR *p);
void  sprint_var(char *dest, VAR *p);
void  print_goal_var(STACK *p);
void  destroy_var(VAR *p);
VAR  *add_var(char *s);
void init_hash( void );


#endif
