/*
  clause.c
*/


#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
//#include <malloc.h>

#include "clause.h"
#include "struct.h"
#include "p97.h"
#include "garb.h"
#include "parse.h"


DB *src = NULL, *rt_src = NULL;

static int diff(char *f, char *line);
static void doquery();

int readsource(char *fname)
{
  DB *p;
  FILE *f;
  int r;
  char buf[LINE_L + 1];

  if ((f = fopen(fname, "rt")) == NULL)
	return 0;

  p = src = (DB *)mymalloc(sizeof(DB));

  if (read_cl(p->line, f) != 1) {
	myfree(src);
	src = NULL;
	return 0;
  }

  while ((r = read_cl(buf, f)) == 1) {
	p->next = (DB *)mymalloc(sizeof(DB));
	p = p->next;
	strcpy(p->line, buf);
  }

  p->next = NULL;
  fclose(f);
  return (r != -1);
}


int read_cl(char *s, FILE *f)
{
  int r;
  char line[LINE_L + 1];
  char *p = s;


  do {
    *p = '\0';
    do {
      line[0] = '\0';
      fgets(line, LINE_L, f);
      p = p + strlen(p);
    } while (((r = sread_cl(p, line)) == 0) && !feof(f));

    inputp = s;

    if (!strcmp(mystrtok(), "?-")) {
      doquery();
      *p = 1;
    }
  } while (*p == 1);

  if (r == 1)
    return parse(s);

  return r;
}

int sread_cl(char *dest, char *src)
{
  while (*src) {
    switch (*src) {
      case ',':
      case '(':
      case ')':
      case '+':
      case '-':
      case '*':
      case '|':
      case '[':
      case ']':
        *dest++ = TOK_SEP;
        *dest++ = *src;
        *dest++ = TOK_SEP;
        break;

      case '=':
        *dest++ = TOK_SEP;
        *dest++ = *src++;
        *dest++ = *src++;
        *dest++ = *src;
        *dest++ = TOK_SEP;
        break;

      case '/':
        if (*(++src) != '/')
          return -1;

        *dest++ = '/';
        *dest++ = '/';
        *dest++ = TOK_SEP;
        break;

      case ':':
      case '?':
	if (*(src + 1) != '-')
	  return -1;

	*dest++ = TOK_SEP;
	*dest++ = *src++;
        *dest++ = *src;
        *dest++ = TOK_SEP;
        break;

      case '%':
        return 0;
	break;

      case '\t':
      case '\n':
        break;

      case '.':
        if (*(src + 1) != '(') {
          *dest = '\0';
          return 1;
        }
        *dest++ = TOK_SEP;
        *dest++ = '.';
	break;

      case '>':
      case '<':
        *dest++ = *src;

        if (*(src + 1) != '=')
          *dest++ = TOK_SEP;
        else {
          *dest++ = '=';
          *dest++ = TOK_SEP;
          src++;
        }
        break;


      default:
        *dest++ = *src;
	break;
    }

    src++;
  }
  *dest = '\0';
  return 0;
}


DB *find_functor(char *functor, DB *p, DB *start)
{
  if (p = (p ? p->next : start))
    while (p && diff(functor, p->line))
      p = p->next;

  return p;
}


  /* ritorna se funct e la prima parola di line sono diverse */
static int diff(char *f, char *line)
{
  char s[TOK_L + 1];

  sscanf(line, "%s", s);
  return strcmp(f, s);
}

void destroy_src(DB *p)
{
  DB *tmp;

  while (p) {
    tmp = p;
    p = p->next;
    myfree(tmp);
  }
}

int runtime(char *s)
{
  DB *tmp = src;
  int r;

  r = readsource(s);
  rt_src = src;
  src = tmp;

  return r;
}

static void doquery()
{
  OBJ st;

  create_head(inputp, &st);
  assert(!strcmp(st.name, "op"));
  op(&st);
  destroy_st(st.child);
}