/*
  status.c
*/

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "unify.h"
#include "status.h"
#include "clause.h"
#include "var.h"
#include "predef.h"
#include "p97.h"
#include "stack.h"


STACK *sts_sp = NULL;


int push_sts(OBJ *g, STATUS *father, CLAUSE *cl)
{
  STATUS sts;

  spec_st(&sts.goal, g, IGNOREBROTHER);

  if (sts.choose = find_cl(sts.goal, cl, NULL)) {
    sts.mark = mark_var();
    copy_st(&sts.goal_brother, g->brother, !IGNOREBROTHER);
    sts.cutted = 0;
    sts.father = father;
    push(&sts, sizeof(STATUS), &sts_sp);
    return 1;
  } else {
    destroy_st(sts.goal);
    return 0;
  }
}


void pop_sts()
{
  STATUS *sts = (STATUS *)sts_sp->data;

  assert(sts_sp);
  destroy_st(sts->goal_brother);
  destroy_st(sts->goal);
  pop(&sts_sp);
}


void redo()
{
  STATUS *sts = (STATUS *)sts_sp->data;

  assert(sts->goal->brother == NULL);
  free_var_st(sts->goal);     /* ripristina stack delle variabili */
  release_var(sts->mark);
}


int solve_back()
{
  CLAUSE cl;
  STATUS *sts;
  STATUS * p;
  int r;

  while (sts_sp) {
    cl.head = cl.body = NULL;
    sts = (STATUS *)sts_sp->data;
    redo();

    if (!sts->cutted && (sts->choose = find_cl(sts->goal, &cl, sts->choose)))
      if (!cl.body || solve_1st(cl.body->child, sts))
        if (solve_1st(sts->goal_brother, sts->father)) {
          p = sts->father;
          r = 1;
          while (p && (r = solve_1st(p->goal_brother, p->father)))
            p = p->father;

          if (r) {
            destroy_st(cl.head);
            destroy_st(cl.body);
            return r;
          }
        }

    destroy_st(cl.head);
    destroy_st(cl.body);
    pop_sts();
  }
  return 0;
}


int solve_1st(OBJ *g, STATUS *father)
{
  STATUS *sts = (sts_sp ? (STATUS *)sts_sp->data : NULL);
  STACK *tmp;
  CLAUSE cl;
  int r;

  cl.head = cl.body = NULL;
  if (g) {
    if (push_sts(g, father, &cl)) {
      sts = (STATUS *)sts_sp->data;
      tmp = sts_sp;

      if (cl.body) {
        if (r = solve_1st(cl.body->child, (STATUS *)tmp->data))
          r = solve_1st(sts->goal_brother, ((STATUS *)tmp->data)->father);

      } else {
        if (r = predef(g)) /* r == 0 solo se predefinito e fallito */
          r = solve_1st(sts->goal_brother, ((STATUS *)tmp->data)->father);
      }
    } else
      r = 0;

  } else
    r = 1;

  destroy_st(cl.head);
  destroy_st(cl.body);
  return r;
}


void destroy_sts()
{
  while (sts_sp)
    pop_sts();
}
