#include <stdio.h>
#include "clause.h"
#include "p97.h"
#include "garb.h"
#include "predef.h"

void print_src( void );
extern int in_hash, in_list;

static int eval(OBJ *st);

PREDEF mypredef[] = {
  { "eval", eval },
  { "", NULL }
};


main()
{
  prolog a("vice.pro");
  printf("----------\n");
  print_src(); getchar();

  enable_predef(mypredef);

  a.solve("a1(5)."); a.print_var();
  a.solve("a2(5)."); a.print_var();
  a.solve("a3(5)."); a.print_var();
  a.solve("a4(5)."); a.print_var();
  a.solve("a5(5)."); a.print_var();
  a.solve("a6(5)."); a.print_var();
//  a.solve("move( [@,@,@,@,@,@,@,@,o], x, Sout).");
//  p.solve("sum([A],[B],[C]).");
//  p.solve("sum(-(0, -(S, -(E, -(N, -(D, nil))))),-(0, -(M, -(O, -(R, -(E, nil))))),-(M, -(O, -(N, -(E, -(Y, nil)))))).");
//  p.solve("sum([0,S,E,N,D],[0,M,O,R,E],[M,O,N,E,Y]).");
//  p.solve("p(X).");
//  printf("\nocchio:%s\n", p.sget_var("X"));
//  p.print_var();

printf("hash: %d\nlist: %d\n", in_hash, in_list);
}


void print_src()
{
  DB *p = src;

  while (p) {
    printf("!!!!%s\n", p->line); getchar();
    p = p->next;
  }
}

static int eval(OBJ *st)
{
  static int n = 1;
  OBJ st2;

  if (!isvar_st(getobj(st->child->brother->brother)))
    return 0;

  sprintf(st2.name, "%d", ++n);
  st2.arity = 0;
  st2.child = st2.brother = NULL;
  link_var(getobj(st->child->brother->brother), &st2);

  return 1;
}