
#define dump_c(c)  ((**dest = (c)), (*dest)++)

void unparse_list(char *dest)
{
  char buf[LINE_L + 1], *p = buf;

  strcpy(buf, dest);

  while (*p) {
    if ((*p == '.') || (*p == '$'))
      p = unparse_bracket(&dest, p);

    else
      *dest++ = *p++;
  }
}

static char *unparse_bracket(char **dest, char *src)
{
  int bracketc, elemc;


  if (*src == '$') {
    dump(dest, "[]");
    return src + 1;
  }

  src += 2;
  elemc = 1;
  bracketc = 0;
  dump_c('[');

  while (*src && elemc) {
    switch (*src) {
      case '.':
        assert(*(src + 1) == '(');
        src += 2;
        elemc++;

        if (*src == '.')
          src = unparse_bracket(dest, src);
        break;

      case ',':
        if (bracketc == 0) {
          if ((*(src + 1) != '$') && (*(src + 1) != '.'))
            dump_c('|');
          else
            src += 2;
        else {
          dump_c(',');
          src++;
        }
        break;

      case ')':
        if (bracketc == 0) {
          dump_c(']');
          src += elemc;
          elemc = 0;
        } else
          bracketc--;
        break;

      case '(':
        bracketc++;
        dump_c(*src);
        src++;
        break;

      default:
        dump_c(*src);
        src++;
    }
  }

  return src;
}